# -*- coding: mbcs -*-
from part import *
from material import *
from section import *
from assembly import *
from step import *
from interaction import *
from load import *
from mesh import *
from optimization import *
from job import *
from sketch import *
from visualization import *
from connectorBehavior import *



import random
global n
n=random.randrange(11,20)
n=str(n)

global labo
global test
labo=False
visco=True
mullins=False


def build():
  ### model axisymmetric
  
  ##hodnoty
  prumer=9.5e-3
  polomer=float(prumer/2) #[m]
  vyska=2e-3
  ##posuv
  posuv_y=-1.5e-3  ## - pro tlakové zatížení  # stejně se změní
  
  element_size=0.0003
  
  
  import os 
  crdir=os.getcwd()
  cesta=str(crdir+n+'.cae')
  
  mdb.saveAs(pathName=cesta)
  ## vzorek
  
  mdb.models['Model-1'].ConstrainedSketch(name='__profile__', sheetSize=0.02)
  mdb.models['Model-1'].sketches['__profile__'].sketchOptions.setValues(
      decimalPlaces=4, viewStyle=AXISYM)
  mdb.models['Model-1'].sketches['__profile__'].ConstructionLine(point1=(0.0, 
      -0.01), point2=(0.0, 0.01))
  mdb.models['Model-1'].sketches['__profile__'].FixedConstraint(entity=
      mdb.models['Model-1'].sketches['__profile__'].geometry[2])
  mdb.models['Model-1'].sketches['__profile__'].rectangle(point1=(0.0, 0.0), 
      point2=(polomer, vyska))
  mdb.models['Model-1'].Part(dimensionality=AXISYMMETRIC, name='Part-1', type=
      DEFORMABLE_BODY)
  mdb.models['Model-1'].parts['Part-1'].BaseShell(sketch=
      mdb.models['Model-1'].sketches['__profile__'])
  del mdb.models['Model-1'].sketches['__profile__']
  
  ## vzorek oznaceni ploch
  mdb.models['Model-1'].parts['Part-1'].Surface(name='horni_plocha', side1Edges=
    mdb.models['Model-1'].parts['Part-1'].edges.getSequenceFromMask(('[#4 ]', 
    ), ))
  mdb.models['Model-1'].parts['Part-1'].Surface(name='dolni_plocha', side1Edges=
    mdb.models['Model-1'].parts['Part-1'].edges.getSequenceFromMask(('[#1 ]', 
    ), ))
  
  
  
  
  ## celisti
  
  mdb.models['Model-1'].ConstrainedSketch(name='__profile__', sheetSize=0.01)
  mdb.models['Model-1'].sketches['__profile__'].sketchOptions.setValues(
      decimalPlaces=4, viewStyle=AXISYM)
  mdb.models['Model-1'].sketches['__profile__'].ConstructionLine(point1=(0.0, 
      -0.005), point2=(0.0, 0.005))
  mdb.models['Model-1'].sketches['__profile__'].FixedConstraint(entity=
      mdb.models['Model-1'].sketches['__profile__'].geometry[2])
  mdb.models['Model-1'].sketches['__profile__'].Line(point1=(0.0, 0.0), point2=(
      0.0055, 0.0))
  mdb.models['Model-1'].sketches['__profile__'].HorizontalConstraint(
      addUndoState=False, entity=
      mdb.models['Model-1'].sketches['__profile__'].geometry[3])
  mdb.models['Model-1'].Part(dimensionality=AXISYMMETRIC, name='Part-2', type=
      ANALYTIC_RIGID_SURFACE)
  mdb.models['Model-1'].parts['Part-2'].AnalyticRigidSurf2DPlanar(sketch=
      mdb.models['Model-1'].sketches['__profile__'])
  del mdb.models['Model-1'].sketches['__profile__']
  
  mdb.models['Model-1'].parts['Part-2'].ReferencePoint(point=
    mdb.models['Model-1'].parts['Part-2'].vertices[1])
  
  #Section and Section assigment
  mdb.models['Model-1'].HomogeneousSolidSection(material='Korek', name=
      'Section-1', thickness=None)
  mdb.models['Model-1'].parts['Part-1'].Set(faces=
      mdb.models['Model-1'].parts['Part-1'].faces.getSequenceFromMask(('[#1 ]', 
      ), ), name='Set-1')
  
                          
  ##assembly
  
  mdb.models['Model-1'].rootAssembly.Instance(dependent=ON, name='Part-2-1', 
    part=mdb.models['Model-1'].parts['Part-2'])
  mdb.models['Model-1'].rootAssembly.Instance(dependent=ON, name='Part-2-2', 
    part=mdb.models['Model-1'].parts['Part-2'])
  mdb.models['Model-1'].rootAssembly.translate(instanceList=('Part-2-2', ), 
    vector=(0.0, vyska, 0.0))
  
  mdb.models['Model-1'].parts['Part-1'].SectionAssignment(offset=0.0, 
      offsetField='', offsetType=MIDDLE_SURFACE, region=
      mdb.models['Model-1'].parts['Part-1'].sets['Set-1'], sectionName=
      'Section-1', thicknessAssignment=FROM_SECTION)
  mdb.models['Model-1'].rootAssembly.DatumCsysByThreePoints(coordSysType=
      CYLINDRICAL, origin=(0.0, 0.0, 0.0), point1=(1.0, 0.0, 0.0), point2=(0.0, 
      0.0, -1.0))
  mdb.models['Model-1'].rootAssembly.Instance(dependent=OFF, name='Part-1-1', 
      part=mdb.models['Model-1'].parts['Part-1'])
  ## kontakt a treni 
  
  mdb.models['Model-1'].ContactProperty('IntProp-1')
  mdb.models['Model-1'].interactionProperties['IntProp-1'].TangentialBehavior(
      dependencies=0, directionality=ISOTROPIC, elasticSlipStiffness=None, 
      formulation=PENALTY, fraction=0.005, maximumElasticSlip=FRACTION, 
      pressureDependency=OFF, shearStressLimit=None, slipRateDependency=OFF, 
      table=((0.7, ), ), temperatureDependency=OFF)
  mdb.models['Model-1'].rootAssembly.Surface(name='m_Surf-1', side2Edges=
      mdb.models['Model-1'].rootAssembly.instances['Part-2-2'].edges.getSequenceFromMask(
      ('[#1 ]', ), ))
  mdb.models['Model-1'].SurfaceToSurfaceContactStd(adjustMethod=NONE, 
      clearanceRegion=None, createStepName='Initial', datumAxis=None, 
      initialClearance=OMIT, interactionProperty='IntProp-1', master=
      mdb.models['Model-1'].rootAssembly.surfaces['m_Surf-1'], name='Int-1', 
      slave=
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].surfaces['horni_plocha']
      , sliding=FINITE, thickness=ON)
  mdb.models['Model-1'].rootAssembly.Surface(name='m_Surf-2', side1Edges=
      mdb.models['Model-1'].rootAssembly.instances['Part-2-1'].edges.getSequenceFromMask(
      ('[#1 ]', ), ))
  mdb.models['Model-1'].SurfaceToSurfaceContactStd(adjustMethod=NONE, 
      clearanceRegion=None, createStepName='Initial', datumAxis=None, 
      initialClearance=OMIT, interactionProperty='IntProp-1', master=
      mdb.models['Model-1'].rootAssembly.surfaces['m_Surf-2'], name='Int-2', 
      slave=
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].surfaces['dolni_plocha']
      , sliding=FINITE, thickness=ON)
  
  
  
  
  # Materiál
  import matmodel as mamo
  mamo.mat()

  #mesh
  mdb.models['Model-1'].rootAssembly.Instance(dependent=OFF, name='Part-1-1', 
      part=mdb.models['Model-1'].parts['Part-1'])
  mdb.models['Model-1'].rootAssembly.setElementType(elemTypes=(ElemType(
      elemCode=CAX4RH, elemLibrary=STANDARD, hourglassControl=DEFAULT), ElemType(
      elemCode=CAX3, elemLibrary=STANDARD)), regions=(
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].faces.getSequenceFromMask(
      ('[#1 ]', ), ), ))
  mdb.models['Model-1'].rootAssembly.seedPartInstance(deviationFactor=0.1, 
      minSizeFactor=0.1, regions=(
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'], ), size=element_size)
  mdb.models['Model-1'].rootAssembly.generateMesh(regions=(
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'], ))
  


   
#   v1=-0.6e-3
#   v2=-0.9e-3
#   v3=-1.5e-3
#   v4=-2.1e-3
  v1=-0.2e-3
  v2=-0.3e-3
  v3=-0.5e-3
  v4=-0.7e-3
  
  ddt=37.59 #[0,0.25]
  dt=22.55 #[0.25,0.1]
  dt2=ddt #[0.1,0.35]
  dt3=30.00 #[0.15,0.35]
  t1=60
  t2=120
  
#   u=[0,v3]
#   tp=[0,ddt]

  
  u=[0,v3,v3,v1,v1]
  tp=[0,ddt,t1,dt,t1]
 # u=[0,v3,v3,v1,v1,v3,v3,v1,v1,v3,v3,v1,v1,v3,v3,v1,v1,v4,v4,v2,v2,v4,v4,v2,v2,v4,v4,v2,v2,v4,v4,v2,]
 
 #tp=[0,ddt,t1,dt,t1,dt,t1,dt,t1,dt,t1,dt,t2,dt,t2,dt,t2,dt2,t1,dt3,t1,dt3,t1,dt3,t1,dt3,t1,dt3,t2,dt3,t2,dt3] 


  time=[0,0]
  for i in range(len(tp)):
   time.append(time[-1]+tp[i])
  del time[0]
  del time[1]  
  
  d=[]
  for i in range(len(tp)):
    d.append((time[i],u[i]))     
  cas_vypoctu=time[-1]
  
  mdb.models['Model-1'].TabularAmplitude(data=d,
  name='tabulka', smooth=SOLVER_DEFAULT, timeSpan=STEP)

  #inkrementace
  kroky=100

  mdb.models['Model-1'].ViscoStep(adaptiveDampingRatio=0.05, cetol=0.0, 
    continueDampingFactors=True, initialInc=time[-1]/kroky, maxNumInc=kroky, name='krok'
    , nlgeom=ON, previous='Initial', stabilizationMethod=
    DISSIPATED_ENERGY_FRACTION, timeIncrementationMethod=FIXED, timePeriod=
    time[-1])

  #BC
  
  mdb.models['Model-1'].rootAssembly.Set(name='Set-2', referencePoints=(
    mdb.models['Model-1'].rootAssembly.instances['Part-2-1'].referencePoints[2], 
    ))
  mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='Initial', 
    distributionType=UNIFORM, fieldName='', localCsys=None, name='BC-1', 
    region=mdb.models['Model-1'].rootAssembly.sets['Set-2'], u1=SET, u2=SET, 
    ur3=SET)
  mdb.models['Model-1'].rootAssembly.Set(name='Set-3', referencePoints=(
    mdb.models['Model-1'].rootAssembly.instances['Part-2-2'].referencePoints[2], 
    ))
  mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='krok', 
    distributionType=UNIFORM, fieldName='', fixed=OFF, localCsys=None, name=
    'BC-2', region=mdb.models['Model-1'].rootAssembly.sets['Set-3'], u1=0.0, 
    u2=posuv_y, ur3=0.0)
   
   
  mdb.models['Model-1'].DisplacementBC(amplitude='tabulka', createStepName='krok', 
    distributionType=UNIFORM, fieldName='', fixed=OFF, localCsys=None, name=
    'BC-2', region=mdb.models['Model-1'].rootAssembly.sets['Set-3'], u1=0.0, 
    u2=1, ur3=0.0)
  

  
  
  

  #sety
  mdb.models['Model-1'].parts['Part-1'].Set(name='posuv', vertices=
      mdb.models['Model-1'].parts['Part-1'].vertices.getSequenceFromMask((
      '[#8 ]', ), ))
      
  mdb.models['Model-1'].parts['Part-2'].Set(name='ref_roviny', referencePoints=(
    mdb.models['Model-1'].parts['Part-2'].referencePoints[2], ))    
      
  
  #history
  mdb.models['Model-1'].HistoryOutputRequest(createStepName='krok', name=
    'reakcni_sila', rebar=EXCLUDE, region=
    mdb.models['Model-1'].rootAssembly.instances['Part-2-1'].sets['ref_roviny']
    , sectionPoints=DEFAULT, variables=('RF2', ))
  mdb.models['Model-1'].HistoryOutputRequest(createStepName='krok', name='pousuv', 
    rebar=EXCLUDE, region=
    mdb.models['Model-1'].rootAssembly.instances['Part-2-2'].sets['ref_roviny']
    , sectionPoints=DEFAULT, variables=('U2', ))
  
  
  

  mdb.Job(atTime=None, contactPrint=OFF, description='', echoPrint=OFF, 
      explicitPrecision=SINGLE, getMemoryFromAnalysis=True, historyPrint=OFF, 
      memory=90, memoryUnits=PERCENTAGE, model='Model-1', modelPrint=OFF, name=
      'Job-'+n, nodalOutputPrecision=SINGLE, queue=None, scratch='', type=ANALYSIS
      , userSubroutine='', waitHours=0, waitMinutes=0)
  if labo==True:
    mdb.jobs['Job-'+n].setValues(multiprocessingMode=THREADS, numCpus=12,numDomains=12)
  mdb.jobs['Job-'+n].submit(consistencyChecking=OFF)
  mdb.jobs['Job-'+n].waitForCompletion()      
  
         
  


build()
from output_fem_tlak import output
# os.remove('output_fem_tlak.txt') 
output(n)
# from perform import perform
# perform('tlak')