# -*- coding: mbcs -*-
from part import *
from material import *
from section import *
from assembly import *
from step import *
from interaction import *
from load import *
from mesh import *
from optimization import *
from job import *
from sketch import *
from visualization import *
from connectorBehavior import *
import os





import random
global labo
global test
global visco

labo=False
visco=True
mullins=False

## náhodný název kvůli kolizím při více vláknech
global n
n=random.randrange(0,10)
n=str(n)

### MODEL
def build():
  

  
  import os                     
  crdir=os.getcwd()
  cesta=str(crdir+n+'.cae')
  
  mdb.saveAs(pathName=cesta)
  
  # Model
  # Použit pouze střed pádla a bude využito symetrie podle všech 3 os.
  
  delka= 10e-3
  sirka= 6e-3
  tloustka= 2.00e-3
  posunuti=2.5e-3
 
  
  element_size=0.00060
  
  
  # Symetrie podle 3 => děláme 1/8 obdélníku
  
  delka=float(delka/2)
  sirka=float(sirka/2)
  tloustka=float(tloustka/2)
  posunuti=float(posunuti/2)
  
  mdb.models['Model-1'].ConstrainedSketch(name='__profile__', sheetSize=0.005)
  mdb.models['Model-1'].sketches['__profile__'].sketchOptions.setValues(
      decimalPlaces=4)
  mdb.models['Model-1'].sketches['__profile__'].rectangle(point1=(0.0, 0.0), 
      point2=(sirka, delka))
  mdb.models['Model-1'].sketches['__profile__'].autoDimension(objectList=(
      mdb.models['Model-1'].sketches['__profile__'].geometry[2], 
      mdb.models['Model-1'].sketches['__profile__'].geometry[3], 
      mdb.models['Model-1'].sketches['__profile__'].geometry[4], 
      mdb.models['Model-1'].sketches['__profile__'].geometry[5]))
  mdb.models['Model-1'].Part(dimensionality=THREE_D, name='Part-1', type=
      DEFORMABLE_BODY)
  mdb.models['Model-1'].parts['Part-1'].BaseSolidExtrude(depth=tloustka, sketch=
      mdb.models['Model-1'].sketches['__profile__'])
  del mdb.models['Model-1'].sketches['__profile__']
  
  
  import matmodel as mamo
  mamo.mat()
  
  mdb.models['Model-1'].HomogeneousSolidSection(material='Korek', name=
      'Section-1', thickness=None)
  mdb.models['Model-1'].parts['Part-1'].Set(cells=
      mdb.models['Model-1'].parts['Part-1'].cells.getSequenceFromMask(('[#1 ]', 
      ), ), name='Set-1')
  mdb.models['Model-1'].parts['Part-1'].SectionAssignment(offset=0.0, 
      offsetField='', offsetType=MIDDLE_SURFACE, region=
      mdb.models['Model-1'].parts['Part-1'].sets['Set-1'], sectionName=
      'Section-1', thicknessAssignment=FROM_SECTION)
  
  # Assembly
  mdb.models['Model-1'].parts['Part-1'].Set(cells=
      mdb.models['Model-1'].parts['Part-1'].cells.getSequenceFromMask(('[#1 ]', 
      ), ), name='Set-1')
  mdb.models['Model-1'].parts['Part-1'].SectionAssignment(offset=0.0, 
      offsetField='', offsetType=MIDDLE_SURFACE, region=
      mdb.models['Model-1'].parts['Part-1'].sets['Set-1'], sectionName=
      'Section-1', thicknessAssignment=FROM_SECTION)
  mdb.models['Model-1'].rootAssembly.DatumCsysByDefault(CARTESIAN)
  mdb.models['Model-1'].rootAssembly.Instance(dependent=OFF, name='Part-1-1', 
      part=mdb.models['Model-1'].parts['Part-1'])
  
  
  
  
  # Mesh
  mdb.models['Model-1'].rootAssembly.setElementType(elemTypes=(ElemType(
      elemCode=C3D8RH, elemLibrary=STANDARD, kinematicSplit=AVERAGE_STRAIN, 
      hourglassControl=DEFAULT), ElemType(elemCode=C3D6, elemLibrary=STANDARD), 
      ElemType(elemCode=C3D4, elemLibrary=STANDARD)), regions=(
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].cells.getSequenceFromMask(
      ('[#1 ]', ), ), ))
  mdb.models['Model-1'].rootAssembly.seedPartInstance(deviationFactor=0.1, 
      minSizeFactor=0.1, regions=(
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'], ), size=element_size)
  mdb.models['Model-1'].rootAssembly.generateMesh(regions=(
      mdb.models['Model-1'].rootAssembly.instances['Part-1-1'], ))
      

      
  #Okrajové podmínky
  
  
  
  
  
  # tabulka pro okrajové podmínky
  v1=1.0e-3/2
  v2=1.5e-3/2
  v3=2.5e-3/2
  v4=3.5e-3/2
  
  ddt=37.31 #[0,0.25]
  dt=22.39 #[0.25,0.1]
  dt2=ddt #[0.1,0.35]
  dt3=29.85 #[0.15,0.35]
  t1=60
  t2=120
  
#   u=[0,v3]
#   tp=[0,ddt]  
  
#   u=[0,v3,v3]
#   tp=[0,ddt,t1]
  
  u=[0,v3,v3,v1,v1]
  tp=[0,ddt,t1,dt,t1]
 # u=[0,v3,v3,v1,v1,v3,v3,v1,v1,v3,v3,v1,v1,v3,v3,v1,v1,v4,v4,v2,v2,v4,v4,v2,v2,v4,v4,v2,v2,v4,v4,v2,]
 
 #tp=[0,ddt,t1,dt,t1,dt,t1,dt,t1,dt,t1,dt,t2,dt,t2,dt,t2,dt2,t1,dt3,t1,dt3,t1,dt3,t1,dt3,t1,dt3,t2,dt3,t2,dt3] 


  time=[0,0]
  for i in range(len(tp)):
   time.append(time[-1]+tp[i])
  del time[0]
  del time[1]  
  
  d=[]
  for i in range(len(tp)):
    d.append((time[i],u[i]))     
  cas_vypoctu=time[-1]
  
  
  
  mdb.models['Model-1'].TabularAmplitude(data=d,
     name='tabulka', smooth=SOLVER_DEFAULT, timeSpan=STEP)

  #inkrementace
  kroky=100
  
  mdb.models['Model-1'].ViscoStep(adaptiveDampingRatio=0.05, cetol=0.0, 
      continueDampingFactors=True, initialInc=time[-1]/kroky, maxNumInc=kroky, name='krok'
      , nlgeom=ON, previous='Initial', stabilizationMethod=
      DISSIPATED_ENERGY_FRACTION, timeIncrementationMethod=FIXED, timePeriod=
      time[-1])

                                
  

  mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='Initial', 
    distributionType=UNIFORM, fieldName='', localCsys=None, name='symx', 
    region=Region(
    faces=mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].faces.getSequenceFromMask(
    mask=('[#1 ]', ), )), u1=SET, u2=UNSET, u3=UNSET, ur1=UNSET, ur2=UNSET, 
    ur3=UNSET)
  mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='Initial', 
    distributionType=UNIFORM, fieldName='', localCsys=None, name='symz', 
    region=Region(
    faces=mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].faces.getSequenceFromMask(
    mask=('[#20 ]', ), )), u1=UNSET, u2=UNSET, u3=SET, ur1=UNSET, ur2=UNSET, 
    ur3=UNSET)
  mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='Initial', 
    distributionType=UNIFORM, fieldName='', localCsys=None, name='symy', 
    region=Region(
    faces=mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].faces.getSequenceFromMask(
    mask=('[#8 ]', ), )), u1=UNSET, u2=SET, u3=UNSET, ur1=UNSET, ur2=UNSET, 
    ur3=UNSET)

  
  mdb.models['Model-1'].DisplacementBC(amplitude=('tabulka'), createStepName='krok', 
    distributionType=UNIFORM, fieldName='', fixed=OFF, localCsys=None, name=
    'posunuti', region=Region(
    faces=mdb.models['Model-1'].rootAssembly.instances['Part-1-1'].faces.getSequenceFromMask(
    mask=('[#2 ]', ), )), u1=UNSET, u2=1, u3=UNSET, ur1=UNSET, ur2=UNSET, 
    ur3=UNSET)
    

     
   

  

        
        
  #sety
  
  mdb.models['Model-1'].parts['Part-1'].Set(name='posuv', vertices=
    mdb.models['Model-1'].parts['Part-1'].vertices.getSequenceFromMask((
    '[#10 ]', ), ))
  mdb.models['Model-1'].parts['Part-1'].Set(faces=
    mdb.models['Model-1'].parts['Part-1'].faces.getSequenceFromMask(('[#8 ]', 
    ), ), name='Reakcni_sila_plocha')
  
 
      
  # job
 
  mdb.Job(atTime=None, contactPrint=OFF, description='', echoPrint=OFF, 
      explicitPrecision=SINGLE, getMemoryFromAnalysis=True, historyPrint=OFF, 
      memory=90, memoryUnits=PERCENTAGE, model='Model-1', modelPrint=OFF, name=
      'Job-'+n, nodalOutputPrecision=SINGLE, queue=None, scratch='', type=ANALYSIS
      , userSubroutine='', waitHours=0, waitMinutes=0)
  if labo==True:
    mdb.jobs['Job-'+n].setValues(multiprocessingMode=THREADS, numCpus=12,numDomains=12)
  
  mdb.jobs['Job-'+n].submit(consistencyChecking=OFF) 
  mdb.jobs['Job-'+n].waitForCompletion()     




build()  
from output_fem_tah import output
 # os.remove('output_fem_tah.txt')
output(n)
