# -*- coding: mbcs -*-
from part import *
from material import *
from section import *
from assembly import *
from step import *
from interaction import *
from load import *
from mesh import *
from optimization import *
from job import *
from sketch import *
from visualization import *
from connectorBehavior import *



import random



global labo
global test
global visco

labo=False
visco=True
mullins=False


global n
n=random.randrange(21,30)
n=str(n)



#mdb.saveAs(pathName='C:/Abaqus/Temp/'+n+'.cae')

def build():
  import os 
  crdir=os.getcwd()
  cesta=str(crdir+n+'.cae')
  
  mdb.saveAs(pathName=cesta)
  
  ## rozmery
  
  a=23.5e-3
  b=15e-3
  t=1.98e-3
  ## symetrick podle jedn osy
#   b=float(b/2.0)
  #posun
  posun=0.594e-3
  
  
  mdb.models['Model-1'].ConstrainedSketch(name='__profile__', sheetSize=0.02)
  mdb.models['Model-1'].sketches['__profile__'].sketchOptions.setValues(
      decimalPlaces=4)
  mdb.models['Model-1'].sketches['__profile__'].rectangle(point1=(0.0, 0.0), 
      point2=(b, t))
  mdb.models['Model-1'].Part(dimensionality=THREE_D, name='Model-1', type=
      DEFORMABLE_BODY)
  mdb.models['Model-1'].parts['Model-1'].BaseSolidExtrude(depth=a, sketch=
      mdb.models['Model-1'].sketches['__profile__'])
  del mdb.models['Model-1'].sketches['__profile__']
  
  
  
  mdb.models['Model-1'].parts['Model-1'].Set(name='posuv', vertices=
      mdb.models['Model-1'].parts['Model-1'].vertices.getSequenceFromMask((
      '[#10 ]', ), ))
  mdb.models['Model-1'].parts['Model-1'].Set(faces=
      mdb.models['Model-1'].parts['Model-1'].faces.getSequenceFromMask(('[#8 ]', 
      ), ), name='reakcni_sila_plocha')
  
  
      
      
  #Assembly
  mdb.models['Model-1'].rootAssembly.Instance(dependent=OFF, name='Model-1-1', 
      part=mdb.models['Model-1'].parts['Model-1'])
      
  import matmodel as mamo
  mamo.mat()  
  
#   mdb.models['Model-1'].Material(name='Korek')
#   mdb.models['Model-1'].materials['Korek'].Hyperelastic(materialType=
#   ISOTROPIC, n=3, table=((c['c10'],c['c01'], c['c20'], c['c11'], 0.0, c['c30'], 0.0, 0.0, 0.0, c['d1'], c['d2'], c['d3']), ), testData=OFF, type=POLYNOMIAL, 
#   volumetricResponse=VOLUMETRIC_DATA)
  

  
#   if visco==True:
#     mdb.models['Model-1'].materials['Korek'].Viscoelastic(domain=TIME, table=((c['g'], 
#     c['k'], c['tau']),(c['g2'], c['k2'], c['tau2'])), time=PRONY)
  
  #section
  
  mdb.models['Model-1'].HomogeneousSolidSection(material='Korek', name=
      'Section-1', thickness=None)
  mdb.models['Model-1'].parts['Model-1'].Set(cells=
      mdb.models['Model-1'].parts['Model-1'].cells.getSequenceFromMask(('[#1 ]', 
      ), ), name='Set-1')
  mdb.models['Model-1'].parts['Model-1'].SectionAssignment(offset=0.0, 
      offsetField='', offsetType=MIDDLE_SURFACE, region=
      mdb.models['Model-1'].parts['Model-1'].sets['Set-1'], sectionName=
      'Section-1', thicknessAssignment=FROM_SECTION)
  
  
  v3=0.594e-3
#   v2=1.5e-3/2
  v1=0.198e-3
#   v4=3.5e-3/2
  
  ddt=22.5 #[0,0.25]
  dt=15 #[0.25,0.1]
#   dt2=ddt #[0.1,0.35]
#   dt3=29.85 #[0.15,0.35]
  t1=60
  t2=120
  
#   u=[0,v3]
#   tp=[0,ddt]  
  
#   u=[0,v3,v3]
#   tp=[0,ddt,t1]
  
  u=[0,v3,v3,v1,v1]
  tp=[0,ddt,t1,dt,t1]
 # u=[0,v3,v3,v1,v1,v3,v3,v1,v1,v3,v3,v1,v1,v3,v3,v1,v1,v4,v4,v2,v2,v4,v4,v2,v2,v4,v4,v2,v2,v4,v4,v2,]
 
 #tp=[0,ddt,t1,dt,t1,dt,t1,dt,t1,dt,t1,dt,t2,dt,t2,dt,t2,dt2,t1,dt3,t1,dt3,t1,dt3,t1,dt3,t1,dt3,t2,dt3,t2,dt3] 


  time=[0,0]
  for i in range(len(tp)):
   time.append(time[-1]+tp[i])
  del time[0]
  del time[1]  
  
  d=[]
  for i in range(len(tp)):
    d.append((time[i],u[i]))     
  cas_vypoctu=time[-1]
  
  
  
  mdb.models['Model-1'].TabularAmplitude(data=d,
     name='tabulka', smooth=SOLVER_DEFAULT, timeSpan=STEP)
  
  
  
  
      
  # Krok
  kroky=100;
  mdb.models['Model-1'].ViscoStep(adaptiveDampingRatio=0.05, cetol=0.0, 
      continueDampingFactors=True, initialInc=time[-1]/kroky, maxNumInc=kroky, name='krok'
      , nlgeom=ON, previous='Initial', stabilizationMethod=
      DISSIPATED_ENERGY_FRACTION, timeIncrementationMethod=FIXED, timePeriod=
      time[-1])
  
  
  mdb.models['Model-1'].rootAssembly.seedPartInstance(deviationFactor=0.1, 
      minSizeFactor=0.1, regions=(
      mdb.models['Model-1'].rootAssembly.instances['Model-1-1'], ), size=0.0015)
  

  mdb.models['Model-1'].rootAssembly.seedEdgeByNumber(constraint=FINER, edges=
    mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].edges.getSequenceFromMask(
    ('[#80 ]', ), ), number=2)
  mdb.models['Model-1'].rootAssembly.generateMesh(regions=(
    mdb.models['Model-1'].rootAssembly.instances['Model-1-1'], ))
  
  
  
  
  
#   mdb.models['Model-1'].rootAssembly.seedPartInstance(deviationFactor=0.1, 
#       minSizeFactor=0.1, regions=(
#       mdb.models['Model-1'].rootAssembly.instances['Model-1-1'], ), size=0.0009)
#   mdb.models['Model-1'].rootAssembly.generateMesh(regions=(
#       mdb.models['Model-1'].rootAssembly.instances['Model-1-1'], ))
  
  
  quad=True
  
  if quad==True:
  
    mdb.models['Model-1'].rootAssembly.setElementType(elemTypes=(ElemType(
    elemCode=C3D20RH, elemLibrary=STANDARD), ElemType(elemCode=C3D15, 
    elemLibrary=STANDARD), ElemType(elemCode=C3D10, elemLibrary=STANDARD)), 
    regions=(
    mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].cells.getSequenceFromMask(
    ('[#1 ]', ), ), ))  
    
  
  else:
  
    mdb.models['Model-1'].rootAssembly.setElementType(elemTypes=(ElemType(
    elemCode=C3D8RH, elemLibrary=STANDARD, kinematicSplit=AVERAGE_STRAIN, 
    hourglassControl=DEFAULT), ElemType(elemCode=C3D6, elemLibrary=STANDARD), 
    ElemType(elemCode=C3D4, elemLibrary=STANDARD)), regions=(
    mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].cells.getSequenceFromMask(
    ('[#1 ]', ), ), ))  
      
      
 
      
  
  
  
      
  # mdb.models['Model-1'].rootAssembly.deleteSeeds(regions=
  #     mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].edges.getSequenceFromMask(
  #     ('[#fff ]', ), ))
  # mdb.models['Model-1'].rootAssembly.seedEdgeByNumber(constraint=FINER, edges=
  #     mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].edges.getSequenceFromMask(
  #     ('[#c50 ]', ), ), number=4)
  # mdb.models['Model-1'].rootAssembly.seedEdgeByNumber(constraint=FINER, edges=
  #     mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].edges.getSequenceFromMask(
  #     ('[#12a ]', ), ), number=4)
  # mdb.models['Model-1'].rootAssembly.seedEdgeByNumber(constraint=FINER, edges=
  #     mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].edges.getSequenceFromMask(
  #     ('[#285 ]', ), ), number=4)
  # mdb.models['Model-1'].rootAssembly.generateMesh(regions=(
  #     mdb.models['Model-1'].rootAssembly.instances['Model-1-1'], ))    
      
      
  mdb.models['Model-1'].fieldOutputRequests['F-Output-1'].setValues(variables=
    ALL)     
      
      
  
  #BC    
  mdb.models['Model-1'].rootAssembly.Set(faces=
      mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].faces.getSequenceFromMask(
      ('[#8 ]', ), ), name='dolni_plocha')
  mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='Initial', 
      distributionType=UNIFORM, fieldName='', localCsys=None, name='upnuti', 
      region=mdb.models['Model-1'].rootAssembly.sets['dolni_plocha'], u1=SET, u2=
      SET, u3=SET, ur1=UNSET, ur2=UNSET, ur3=UNSET)
  mdb.models['Model-1'].rootAssembly.Set(faces=
      mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].faces.getSequenceFromMask(
      ('[#2 ]', ), ), name='horni_zatezna_plocha')
  mdb.models['Model-1'].DisplacementBC(amplitude='tabulka', createStepName='krok', 
      distributionType=UNIFORM, fieldName='', fixed=OFF, localCsys=None, name=
      'posun', region=
      mdb.models['Model-1'].rootAssembly.sets['horni_zatezna_plocha'], u1=0, 
      u2=0, u3=1, ur1=0, ur2=0, ur3=0)
#   mdb.models['Model-1'].boundaryConditions['posun'].setValues(amplitude=
#     'tabulka')
      
      
#   ##symetrie
#   mdb.models['Model-1'].rootAssembly.Set(faces=
#       mdb.models['Model-1'].rootAssembly.instances['Model-1-1'].faces.getSequenceFromMask(
#       ('[#4 ]', ), ), name='sym')
#   mdb.models['Model-1'].DisplacementBC(amplitude=UNSET, createStepName='Initial', 
#       distributionType=UNIFORM, fieldName='', localCsys=None, name='symetrie', 
#       region=mdb.models['Model-1'].rootAssembly.sets['sym'], u1=SET, u2=UNSET, 
#       u3=UNSET, ur1=UNSET, ur2=UNSET, ur3=UNSET)
  
    # tabulka pro okrajov podmnky

  
  
  
  
  
  mdb.Job(atTime=None, contactPrint=OFF, description='', echoPrint=OFF, 
      explicitPrecision=SINGLE, getMemoryFromAnalysis=True, historyPrint=OFF, 
      memory=90, memoryUnits=PERCENTAGE, model='Model-1', modelPrint=OFF, name=
      'Job-'+n, nodalOutputPrecision=SINGLE, queue=None, scratch='', type=ANALYSIS
      , userSubroutine='', waitHours=0, waitMinutes=0)
  mdb.jobs['Job-'+n].submit(consistencyChecking=OFF) 
  mdb.jobs['Job-'+n].waitForCompletion()    


build()   
 
from output_fem_smyk import output
output(n)
# perform('smyk')