# -*- coding: mbcs -*-
# Do not delete the following import lines
from abaqus import *
from abaqusConstants import *
import __main__

def output(n):
    import section
    import regionToolset
    import displayGroupMdbToolset as dgm
    import part
    import material
    import assembly
    import step
    import interaction
    import load
    import mesh
    import optimization
    import job
    import sketch
    import visualization
    import xyPlot
    import displayGroupOdbToolset as dgo
    import connectorBehavior
  
    session.mdbData.summary()
  
    o3 = session.openOdb(name='Job-'+n+'.odb')
  
    session.viewports['Viewport: 1'].setValues(displayedObject=o3)
  
    odb = session.odbs['Job-'+n+'.odb']
  
    xy_result = session.XYDataFromHistory(name='sila', odb=odb, 
        outputVariableName='Reaction force: RF2 PI: PART-2-1 Node 1 in NSET REF_ROVINY', 
        steps=('krok', ), )
    c1 = session.Curve(xyData=xy_result)
    xyp = session.XYPlot('XYPlot-1')
    chartName = xyp.charts.keys()[0]
    chart = xyp.charts[chartName]
    chart.setValues(curvesToPlot=(c1, ), )
    session.viewports['Viewport: 1'].setValues(displayedObject=xyp)
    odb = session.odbs['Job-'+n+'.odb']
    xy_result = session.XYDataFromHistory(name='posunuti', odb=odb, 
        outputVariableName='Spatial displacement: U2 PI: PART-2-2 Node 1 in NSET REF_ROVINY', 
        steps=('krok', ), )
    c1 = session.Curve(xyData=xy_result)
    xyp = session.xyPlots['XYPlot-1']
    chartName = xyp.charts.keys()[0]
    chart = xyp.charts[chartName]
    chart.setValues(curvesToPlot=(c1, ), )
    x0 = session.xyDataObjects['posunuti']
    x1 = session.xyDataObjects['sila']
    session.writeXYReport(fileName='output_fem_tlak.txt', appendMode=OFF, xyData=(
        x0, x1))


