# Do not delete the following import lines
# -*- coding: utf-8 -*-
from abaqus import *
from abaqusConstants import *
import __main__

def output(n):

  import section
  import regionToolset
  import displayGroupMdbToolset as dgm
  import part
  import material
  import assembly
  import step
  import interaction
  import load
  import mesh
  import optimization
  import job
  import sketch
  import visualization
  import xyPlot
  import displayGroupOdbToolset as dgo
  import connectorBehavior

  n=str(n)
  o1 = session.openOdb(name='Job-'+n+'.odb')
  odb = session.odbs['Job-'+n+'.odb']
  
  ##nasobeni kvuli symetrii
  k_pos=2
  k_sil=-4
  
  
  ###  zjisti pocet iteraci otevrenim posledniho frameu
  numFrame=odb.steps['krok'].frames[-1]
  RForce=numFrame.fieldOutputs['RF']
  regS1 = odb.rootAssembly.instances['PART-1-1'].nodeSets['REAKCNI_SILA_PLOCHA']
  
  k=len(odb.steps['krok'].frames) ## k = pocet inkrementu
  
  ###
  
  
  celkova_sila=[]
  posuv=[]
  cas=[]
    
  
  for k in range (0,k):  # k = pocet inkrementu
     
    
    pocet=len(RForce.getSubset(region=regS1).values) #zjisti pocet reakcnich nodeu
    
    numFrame=odb.steps['krok'].frames[k]  # nacte k-ty frame
    RForce=numFrame.fieldOutputs['RF']    # nacte fieldOutput reakcni sily
    Displacement=numFrame.fieldOutputs['U'] # nacte fieldOutput posunuti
    
    regS1 = odb.rootAssembly.instances['PART-1-1'].nodeSets['REAKCNI_SILA_PLOCHA'] ## vybere sety pro silu a posunuti
    regS2 = odb.rootAssembly.instances['PART-1-1'].nodeSets['POSUV']
    
    posuv.append(k_pos*(Displacement.getSubset(region=regS2).values[0].data[1])) # ziska info o posunuti v danem kroce
    
    cas.append(odb.steps['krok'].frames[k].frameValue) # nacte cas
  
    sila=[];
    
    for n in range(0,pocet): # n = pocet nodeu pro odecteni reakcni sily
      sila.append(k_sil*(RForce.getSubset(region=regS1).values[n].data[1])) 
    celkova_sila.append(sum(sila))  
    # ziska celkovou silu      
  
  
  ## zapis
  
  vystup=(cas,celkova_sila,posuv)
  f=open('output_fem_tah.txt', 'w')
  # f.write('posunuti[m] reakcni_sila[N] \n')
  ## vystup posun [m] sila [N]
  for i in range(0,len(cas)):
    f.write ('%6f;%6f;%6f\n'% (cas[i],celkova_sila[i],posuv[i]))       
  f.close()
  
  
  
